// Craig S. Kaplan
// Rotate an image in the centre of the sketch.

PImage img;
float angle;

void setup()
{
  size( 400, 400 );
  img = loadImage( "titania150.jpg" );
  angle = 0.0;
}

void draw()
{
  background( 255 );
  
  // Note that I describe the transformations
  // below in reverse order.  Yes, they're really
  // applied that way.  The key is to realize that
  // each transformation "sets up a context" in
  // which future transformations operate.  So
  // when you draw something, you walk back outward
  // to the top level, applying the accumulated
  // transformations as you go.
  
  // Finally, move the whole thing down to
  // the centre of the sketch.
  translate( width/2, height/2 );
  // Next, it's safe rotate the image by the
  // current angle.
  rotate( angle );  
  // First, slide the image back so that its
  // centre lies on the point (0,0)
  translate( -img.width/2, -img.height/2 );
  
  image( img, 0, 0 );
  angle += 0.01;
}